/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleEvent;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleListener;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.schedops.Scheduler;
import com.ibm.hwmca.fw.schedops.SchedulerException;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AbstractScheduler
implements Scheduler,
TimeChangedOnConsoleListener {
    private static final String CLASS_NAME = "[AbstractScheduler] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String MESSAGES = "com.ibm.hwmca.fw.schedops.res.message";
    private static final String SCHEDOP_TIMER = "SchedOpsTimer";
    private static final String THREAD_NAME = "SchedulerTask";
    private static final Date EPOCH = new Date(0L);
    protected HashMap inventory = new HashMap();
    protected Object inventoryLock = new Object();
    protected Timer timer = new NamedTimer(true, "SchedOpsTimer");
    private boolean isPHMC = false;

    protected AbstractScheduler() {
        try {
            byte[] type = SimServer.getSimServer().readSim(5);
            this.isPHMC = true;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        TimeManager.getTimeManager().addTimeChangedOnConsoleListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScheduledOperation(ScheduledOperation schedop) throws SchedulerException {
        SchedulerTask task;
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] >> addScheduledOperation() : " + schedop);
        if (schedop == null) {
            throw new IllegalArgumentException("Illegal null value");
        }
        Schedule schedule = schedop.getSchedule();
        Date currDate = new Date();
        Date schedDate = schedule.getNextScheduledDate(currDate);
        Date lastExecuted = schedop.getLastExecutionDate();
        if (lastExecuted != null) {
            Date lastStartWOO = schedule.getNextScheduledDate(lastExecuted);
            Date lastEndWOO = new Date(lastStartWOO.getTime() + schedule.getWindowOfOpportunity());
            if (lastStartWOO.getTime() <= currDate.getTime() && currDate.getTime() <= lastEndWOO.getTime()) {
                schedDate = schedop.getLastExecutionStatus() ? schedule.getNextScheduledDate(new Date(lastEndWOO.getTime() + 1000L)) : lastExecuted;
            }
        }
        if (schedDate != null) {
            task = new SchedulerTask(schedop, null);
            Object object = this.inventoryLock;
            synchronized (object) {
                this.inventory.put(schedop, task);
            }
        } else {
            Trace.trace(TRACE_MASKT, "[AbstractScheduler]    Operation has expired ...");
            throw new SchedulerException("Scheduled Operation has expired");
        }
        Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Scheduling operation at " + new Date() + " ... ");
        Trace.trace(TRACE_MASKF, "[AbstractScheduler]    ... to fire at " + schedDate);
        this.timer.schedule((TimerTask)task, schedDate);
        this.logAdd(schedop);
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] << addScheduledOperation()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScheduledOperation(ScheduledOperation schedop) throws SchedulerException {
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] >> removeScheduledOperation() : " + schedop);
        if (schedop == null) {
            throw new IllegalArgumentException("Illegal null value");
        }
        boolean found = false;
        Object object = this.inventoryLock;
        synchronized (object) {
            SchedulerTask task = (SchedulerTask)this.inventory.get(schedop);
            if (task != null) {
                found = true;
                task.cancel();
                this.inventory.remove(schedop);
            }
        }
        if (found) {
            Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Scheduled Operation removed ...");
            this.logRemove(schedop);
        } else {
            Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Scheduled Operation not found ...");
        }
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] << removeScheduledOperation()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getScheduledOperations(OperationTarget target) throws SchedulerException {
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] >> getScheduledOperations( target ) " + target);
        if (target == null) {
            throw new IllegalArgumentException("Illegal null value");
        }
        ArrayList<ScheduledOperation> result = new ArrayList<ScheduledOperation>();
        Object object = this.inventoryLock;
        synchronized (object) {
            Iterator iterator = this.inventory.keySet().iterator();
            while (iterator.hasNext()) {
                ScheduledOperation schedop = (ScheduledOperation)iterator.next();
                if (!target.equals(schedop.getOperationTarget())) continue;
                result.add(schedop);
            }
        }
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] << getScheduledOperations( target ) : " + result.size());
        return result;
    }

    public List getScheduledOperations(OperationTarget target, Schedulable schedulable) throws SchedulerException {
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] >> getScheduledOperations() : " + target + " : " + schedulable);
        if (target == null || schedulable == null) {
            throw new IllegalArgumentException("Illegal null value");
        }
        List schedops = this.getScheduledOperations(target);
        ArrayList<ScheduledOperation> result = new ArrayList<ScheduledOperation>();
        Iterator iterator = schedops.iterator();
        while (iterator.hasNext()) {
            ScheduledOperation schedop = (ScheduledOperation)iterator.next();
            if (!schedop.getSchedulable().getClass().equals(schedulable.getClass())) continue;
            result.add(schedop);
        }
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] << getScheduledOperations() : " + result.size());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processScheduledOperation(ScheduledOperation schedop, Date firstAttempt) {
        Date nextDate;
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] >> processScheduledOperations()");
        Schedule schedule = schedop.getSchedule();
        boolean success = false;
        long startTime = System.currentTimeMillis();
        long startWOO = schedule.getNextScheduledDate().getTime();
        long endWOO = startWOO + schedule.getWindowOfOpportunity();
        long retryFrequency = (endWOO - startWOO) / 10L;
        schedop.setLastExecutionDate(new Date(startWOO));
        schedop.setLastExecutionStatus(false);
        try {
            schedop.persist();
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, exception);
        }
        this.logStart(schedop);
        while (startTime >= startWOO && startTime <= endWOO && !success) {
            boolean retry = false;
            try {
                Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Execution starts at " + new Date());
                schedop.getSchedulable().performScheduledOperation(schedop);
                Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Execution ends at " + new Date());
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Execution failed at " + new Date() + " ... retry ...");
                retry = true;
            }
            if (!retry) {
                success = true;
                continue;
            }
            try {
                Thread.sleep(retryFrequency);
            }
            catch (Exception e) {
                // empty catch block
            }
            startTime = System.currentTimeMillis();
        }
        schedop.setLastExecutionStatus(true);
        try {
            schedop.persist();
        }
        catch (Exception exception) {
            Trace.trace(TRACE_MASKF, exception);
        }
        if (success) {
            Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Operation execution successful...");
            this.logSuccess(schedop);
        } else {
            Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Operation execution failed...");
            this.logFailure(schedop);
        }
        long nextLong = System.currentTimeMillis();
        if (startWOO <= nextLong && nextLong <= endWOO) {
            nextLong = endWOO + 1000L;
        }
        if ((nextDate = schedule.getNextScheduledDate(new Date(nextLong))) == null) {
            Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Task has expired ...");
            this.expireScheduledOperation(schedop);
        } else {
            SchedulerTask task = new SchedulerTask(schedop, null);
            Object object = this.inventoryLock;
            synchronized (object) {
                this.inventory.put(schedop, task);
            }
            Trace.trace(TRACE_MASKF, "[AbstractScheduler]    Re-Scheduling operation at " + new Date() + " ... ");
            Trace.trace(TRACE_MASKF, "[AbstractScheduler]           ... to fire at " + nextDate);
            this.timer.schedule((TimerTask)task, nextDate);
        }
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] << processScheduledOperations()");
    }

    public void timeChangedOnConsole(TimeChangedOnConsoleEvent event) {
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] >> timeChangedOnConsole()");
        this.reactToTimeChange();
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] << timeChangedOnConsole()");
    }

    protected void reactToTimeChange() {
        this.timer.schedule(new TimerTask(){

            public void run() {
                Trace.trace(AbstractScheduler.TRACE_MASKT, "[AbstractScheduler] <> Reacting to time change ...");
            }
        }, EPOCH);
    }

    protected void logAdd(ScheduledOperation schedop) {
        String[] substData = new String[]{schedop.getSchedulable().getDescriptor().getDescription().toString(), schedop.getCreationUserid().toString(), !this.isPHMC ? schedop.getCreationSourceNetID().toString() + "." + schedop.getCreationSourceName().toString() : schedop.getCreationSourceName().toString()};
        FrameworkEventText fet = new FrameworkEventText(497, substData);
        new SystemEventLog(fet, "SO_SCHED_US").log();
    }

    protected void logRemove(ScheduledOperation schedop) {
        String[] substData = new String[]{schedop.getSchedulable().getDescriptor().getDescription().toString(), schedop.getCreationUserid().toString(), !this.isPHMC ? schedop.getCreationSourceNetID().toString() + "." + schedop.getCreationSourceName().toString() : schedop.getCreationSourceName().toString(), schedop.getCreationDate().toString()};
        FrameworkEventText fet = new FrameworkEventText(483, substData);
        new SystemEventLog(fet, "SO_CAN_USD").log();
    }

    protected void logStart(ScheduledOperation schedop) {
        String[] substData = new String[]{schedop.getSchedulable().getDescriptor().getDescription().toString(), schedop.getCreationUserid().toString(), !this.isPHMC ? schedop.getCreationSourceNetID().toString() + "." + schedop.getCreationSourceName().toString() : schedop.getCreationSourceName().toString(), schedop.getCreationDate().toString()};
        FrameworkEventText fet = new FrameworkEventText(498, substData);
        new SystemEventLog(fet, "SO_START_USD").log();
    }

    protected void logSuccess(ScheduledOperation schedop) {
        String[] substData = new String[]{schedop.getSchedulable().getDescriptor().getDescription().toString(), schedop.getCreationUserid().toString(), !this.isPHMC ? schedop.getCreationSourceNetID().toString() + "." + schedop.getCreationSourceName().toString() : schedop.getCreationSourceName().toString(), schedop.getCreationDate().toString()};
        FrameworkEventText fet = new FrameworkEventText(781, substData);
        new SystemEventLog(fet, "SO_COMPLETE_USD").log();
    }

    protected void logFailure(ScheduledOperation schedop) {
        String[] substData = new String[]{schedop.getSchedulable().getDescriptor().getDescription().toString(), schedop.getCreationUserid().toString(), !this.isPHMC ? schedop.getCreationSourceNetID().toString() + "." + schedop.getCreationSourceName().toString() : schedop.getCreationSourceName().toString(), schedop.getCreationDate().toString()};
        FrameworkEventText fet = new FrameworkEventText(501, substData);
        new SystemEventLog(fet, "SO_FAIL_USD").log();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireScheduledOperation(ScheduledOperation schedop) {
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] >> expireScheduledOperation()");
        Object object = this.inventoryLock;
        synchronized (object) {
            SchedulerTask task = (SchedulerTask)this.inventory.get(schedop);
            if (task != null) {
                task.cancel();
                this.inventory.remove(schedop);
            }
        }
        Trace.trace(TRACE_MASKT, "[AbstractScheduler] << expireScheduledOperation()");
    }

    protected class SchedulerTask
    extends TimerTask {
        protected ScheduledOperation schedop = null;
        protected Date firstAttempt = null;

        public SchedulerTask(ScheduledOperation schedop, Date firstAttempt) {
            if (schedop == null) {
                throw new IllegalArgumentException("Illegal null argument");
            }
            this.schedop = schedop;
            this.firstAttempt = firstAttempt;
        }

        public void run() {
            Thread thread = new Thread(new Runnable(this){
                private final /* synthetic */ SchedulerTask this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    SchedulerTask.access$000(this.this$1).processScheduledOperation(this.this$1.schedop, this.this$1.firstAttempt);
                }
            });
            thread.setName(AbstractScheduler.THREAD_NAME + new Date().getTime());
            thread.start();
        }

        static /* synthetic */ AbstractScheduler access$000(SchedulerTask x0) {
            return x0.AbstractScheduler.this;
        }
    }
}

